package race.operations;

import java.util.ArrayList;
import java.util.Collections;

import race.Operation;

/**
* This implementation of {@link Operation} interface executes the sorting of an
* {@link ArrayList} of integer elements using the method sort() of class {@link Collections}
* 
* @author simone
* @version 1.1
* @see Operation
*
*/
public class ArrayListSortingWithCollectionsSort implements Operation {
	
	private ArrayList<Integer> data;

	@Override
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "Sorting of an ArrayList<Integer> using Collections.sort"+" [executed over "+data.size()+" elements]";
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see contest.Operation#operate()
	 */
	public void operate() {
		Collections.sort(data);
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see contest.Operation#initializeOperationData(java.util.ArrayList)
	 */
	public void initializeOperationData(ArrayList<Integer> randomSeem) {
		this.data = randomSeem;
	}

}
